#!bin/bash
# This environnement works for Ubuntu/debian. Before starting
# you need to make sure that your system has the right compilers
# and libraries

# For CROCO, you will need:
#     - C compiler       (sudo apt-get install gcc )
#     - Fortran compiler (sudo apt-get install gfortran )
#     - Netcdf library   (sudo apt-get install libnetcdf-dev libnetcdff-dev )
#     - MPI library      (sudo apt-get install openmpi-bin libopenmpi-dev )
# For more informations please go here:
#    https://croco-ocean.gitlabpages.inria.fr/croco_doc/index.html 

# If you are coupling with WRF you can check this page:
#     https://www2.mmm.ucar.edu/wrf/OnLineTutorial/compilation_tutorial.php
# to see if you have the proper architecture
# the main libraries you need are ( in addtion to the above):
#     - libpng (sudo apt-get install libpng-dev)
#     - zlib   ( sudo apt-get instal zlib1g-dev)

# Make sure you also have nco tools!




module purge
module load flavor/buildcompiler/intel/20
module load mpi/openmpi/4.1.4.5
module load flavor/hdf5/parallel
module load netcdf-fortran/4.5.3
module load hdf5/1.12.0
module load gnu/11.1.0
module load perl/5.32.1
module load nco
export UCX_TLS=dc_x,cma,knem,self
export OMPI_MCA_io=ompio



#################################################################
################### FOR COMPILATIONS ############################
#################################################################
# -- for NETCDF
# -->
#export NETCDF=$( nf-config --prefix )
#export NETCDF_INC=$(nf-config --includedir)
#export NETCDF_LIB=$( nf-config --flibs)
export NETCDF=${NETCDFFORTRAN_ROOT}
export NETCDF_CONFIG=${NETCDF}/bin/nf-config
export NETCDF_LIBDIR=${NETCDF}/lib
export NETCDF_INCDIR=${NETCDF}/include

# -- Option for job launching
export MPI_LAUNCH=ccc_mprun
export MPI_ext="-f"
export ncomod='nco'

export OMPI_MCA_io=ompio


#----------------------------------------------------------------
# Environment variables related to compilers
#----------------------------------------------------------------
export CC=icc
export FC=ifort
export F77=ifort
export F90=ifort
export MPIF90=mpif90
export MPICC=mpif90

#-------------
# WRF
#-------------
export NETCDF4=1
export NETCDF_classic=1
export WRFIO_NCD_LARGE_FILE_SUPPORT=1
#-------------
# WPS
#-------------
export JASPERLIB=""
export JASPERINC=""
#-------------
# WW3
#-------------
export WWATCH3_NETCDF=NC4

#################################################################
####################### NEEDED PATHS ############################
#################################################################

#-------------------------------------------------------------------------------
# Machine settings
#-------------------------------------------------------------------------------
export MACHINE="IRENE"
#-------------------------------------------------------------------------------
# Config paths
#-------------------------------------------------------------------------------
export CONFIG=Eurec4a_owa
export CHOME=/ccc/work/cont005/gen7298/conejerc/Models/coupled/Eurec4a_owa
export CWORK=/ccc/scratch/cont005/gen7298/conejerc/Eurec4a_owa

#-------------------------------------------------------------------------------
# Tools paths
#-------------------------------------------------------------------------------
export SCRIPTDIR=$CHOME/SCRIPTS_TOOLBOX

#-------------------------------------------------------------------------------
# Model source paths #Insert the full path ( do not use "~" for home )
#-------------------------------------------------------------------------------

export CPL="/ccc/work/cont005/gen7298/conejerc/Models/oasis/oasis3-mct-OASIS3-MCT_4.0/Irene"
export OCE="/ccc/work/cont005/gen13051/conejerc/coupled/CROCO/croco-master/OCEAN"
export ATM="/ccc/work/cont005/gen7298/conejerc/Models/WRF/WRF-CROCO"
export WAV="/ccc/work/cont005/gen7298/conejerc/Models/WW3/model"
export TOY="${CHOME}/TOY_IN"
export XIOS="/ccc/work/cont005/gen7298/conejerc/Models/xios/xios-2.5_coupled_lionel"

#-------------------------------------------------------------------------------
# OASIS
#-------------------------------------------------------------------------------
export CPL_NAM_DIR="$CHOME/OASIS_IN"
#-------------------------------------------------------------------------------
# OCE
#-------------------------------------------------------------------------------
export OCE_NAM_DIR="$CHOME/CROCO_IN"
export OCE_FILES_DIR="$CWORK/CROCO_FILES"
export OCE_FILES_ONLINEDIR=""

#-------------------------------------------------------------------------------
# ATM
#-------------------------------------------------------------------------------
export ATM_NAM_DIR="$CHOME/WRF_IN"
export ATM_FILES_DIR="$CWORK/WRF_FILES"

#-------------------------------------------------------------------------------
# WAV
#-------------------------------------------------------------------------------
export WAV_NAM_DIR="$CHOME/WW3_IN"
export WAV_FILES_DIR="$CWORK/WW3_FILES"

#-------------------------------------------------------------------------------
# TOY
#-------------------------------------------------------------------------------
export TOY_NAM_DIR="$CHOME/TOY_IN"

#------------------------------------------------------------------------------
# XIOS
#-------------------------------------------------------------------------------
export XIOS_NAM_DIR="$CHOME/XIOS_IN"

